﻿Microsoft.Plugin.addEventListener("pluginready", function () {
    setCommonHtmlText();
});

function setTextContent(selector, contentKey) {
    var content = Microsoft.Plugin.Resources.getString(contentKey);
    document.querySelector(selector).innerHTML = content;
}

function setAltText(selector, contentKey) {
    var content = Microsoft.Plugin.Resources.getString(contentKey);
    document.querySelector(selector).setAttribute('alt', content);
}

function setCommonHtmlText() {
    // resource strings used by all overview pages
    setTextContent("#buildYourAppHeader", "BuildYourAppHeader");
    setTextContent("#addServiceHeader", "AddServiceHeader");
    setTextContent("#deployHeader", "DeployHeader");

    setTextContent("#browseDocsText", "BrowseDocsText");

    setTextContent("#telemetryText", "TelemetryText");
    setTextContent("#moreServicesText", "MoreServicesText");

    setTextContent("#continuousDeliveryText", "ContinuousDeliveryText");

    setAltText("#buildYourAppAltText", "BuildYourAppHeader");
    setAltText("#addServiceAltText", "AddServiceHeader");
    setAltText("#deployAltText", "DeployHeader");
}
